/*
  Name: asttapi.cpp
  Copyright: Under the Mozilla Public License Version 1.1 or later
  Author: Nick Knight
  Date: 20/02/04 15:00
  Description: 
*/
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Asttapi.
 *
 * The Initial Developer of the Original Code is
 * Nick Knight.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): none
 *
 * Alternatively, the contents of this file may be used under the terms of
 * the GNU General Public License Version 2 or later (the "GPL")
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

// WaveTsp.h

#ifndef WAVETSP_H
#define WAVETSP_H

#define DIM(rg) (sizeof(rg)/sizeof(*rg))

// Data sent back and forth between UI and TSP during a dial operation
class CtspCall;

struct TSPUIDATA
{
    CtspCall*   pCall;          // Call operation is happening on
    DWORD       dwRequestID;    // Asynch. operation ID
    LONG        tr;             // Asynch, operation result
    DWORD       nCallState;     // New call state
};

#define DEBUGTSP
#if defined(_DEBUG) && defined(DEBUGTSP)

enum ParamType
{
    ptDword,
    ptString,
};

enum ParamDirection
{
    dirIn,
    dirOut,
};

struct FUNC_PARAM
{
    const char*     pszVal;
    DWORD           dwVal;
    ParamType       pt;
    ParamDirection  dir;
};

struct FUNC_INFO
{
    const char* pszFuncName;
    DWORD       dwNumParams;
    FUNC_PARAM* rgParams;
    LONG        lResult;
};

void Prolog(FUNC_INFO* pInfo);
LONG Epilog(FUNC_INFO* pInfo, LONG lResult);

#define BEGIN_PARAM_TABLE(fname) \
    const char* __pszFname = fname; \
    FUNC_PARAM __params[] = {

#define DWORD_IN_ENTRY(p) { #p, (DWORD)p, ptDword, dirIn },
#define DWORD_OUT_ENTRY(p) { #p, (DWORD)p, ptDword, dirOut },
#define STRING_IN_ENTRY(p) { #p, (DWORD)p, ptString, dirIn },
#define STRING_OUT_ENTRY(p) { #p, (DWORD)p, ptString, dirOut },

#define END_PARAM_TABLE() \
    }; FUNC_INFO __info = { __pszFname, DIM(__params), __params }; \
    Prolog(&__info);

#define EPILOG(r) Epilog(&__info, r)

#define TSPTRACE TspTrace
void TspTrace(LPCTSTR pszFormat, ...);

#else   // !_DEBUG

#define EPILOG(r) r

#define BEGIN_PARAM_TABLE(fname)
#define DWORD_IN_ENTRY(p)
#define DWORD_OUT_ENTRY(p)
#define STRING_IN_ENTRY(p)
#define STRING_OUT_ENTRY(p)
#define END_PARAM_TABLE()

#define TSPTRACE TspTrace
inline void TspTrace(LPCTSTR pszFormat, ...) {}

#endif  // _DEBUG

#endif  // WAVETSP_H