/*
  Name: astTspGlue.h
  Copyright: Under the Mozilla Public License Version 1.1 or later
  Author: Nick Knight
  Date: 18/04/2004 21:00
  Description: Maintains information to tie TAPI and asterisk together
*/
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Asttapi.
 *
 * The Initial Developer of the Original Code is
 * Nick Knight.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): none
 *
 * Alternatively, the contents of this file may be used under the terms of
 * the GNU General Public License Version 2 or later (the "GPL")
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#pragma once

#include <tspi.h>
#include <tapi.h>
#include <string>

#include "utilities.h"


//This class maps out a call in Asterisk to a call in TAPI
class astTspGlue
{
public:
	astTspGlue(void);
	~astTspGlue(void);

	DWORD signalTapiRinging(void);
	DWORD signalTapiNewCall(void);
	DWORD setTapiLine(HTAPILINE htLine);
	DWORD setLineEvent(LINEEVENT callBack);
	DWORD getState(void);

private:
	std::string peerAddress;
	std::string callerID;
	std::string callerName;
	std::string astChannelID;
	//are we terminating or originating?
#define TERMINATE 0
#define ORIGINATE 1
	BOOL termOrOrig;

	HTAPILINE ourLine;
	//need some help on the following two!!
	HTAPICALL tapiCall;
	HDRVCALL tspiCall;

	Mutex hdCallMut;

	LINEEVENT lineEvent;

#define callStIdle LINECALLSTATE_IDLE
#define callStOutgoing LINECALLSTATE_DIALING
#define callStIncomingNew (LINECALLSTATE_IDLE | LINECALLSTATE_OFFERING)
#define callStOffered LINECALLSTATE_OFFERING
#define callStIncomingRinging (LINECALLSTATE_OFFERING | LINECALLSTATE_ACCEPTED)
#define callStIncomingConnected LINECALLSTATE_CONNECTED

	DWORD state;
	DWORD ringCount;
	
public:
	DWORD signalTapiIdle(void);
	DWORD setTapiCall(HTAPICALL hCall);
	DWORD signalTapiConnected(void);
	DWORD setCaller(std::string caller);
	DWORD setDest(std::string dest);
	DWORD signalTapiCallerID(std::string info);
	DWORD signalTapiCallOffering(void);
	HDRVCALL getTspiCallID(void);
	std::string getCallerID(void);
	DWORD signalTapiDialing(std::string extension);
	DWORD signalTapiOutgoing(void);
	std::string getPeerAddress(void);
	DWORD setAstChannelID(std::string channel);
	std::string getAstChannelID(void);
	std::string getCallerName(void);
};
