// astloader.cpp : Defines the entry point for the application.
//
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Asttapi.
 *
 * The Initial Developer of the Original Code is
 * Nick Knight.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): none
 *
 * Alternatively, the contents of this file may be used under the terms of
 * the GNU General Public License Version 2 or later (the "GPL")
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "stdafx.h"
#include "astloader.h"
#include <tapi.h>
#include "plhelp.h"
#define MAX_LOADSTRING 100



int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	LPCSTR pszProvider = "asttapi.tsp";
	LPCSTR pszTitle = "TSP Installation";
	LPCSTR pszMessage = 0;

    if( strcmpi(lpCmdLine, "/remove") == 0 )
    {
        DWORD dwID;
        if( GetPermanentProviderID(pszProvider, &dwID) )
        {
            if( lineRemoveProvider(dwID, 0) == 0 )
            {
                pszMessage = "TSP removed.";
            }
            else
            {
                pszMessage = "TSP cannot be removed.";
            }
        }
        else
        {
            pszMessage = "TSP not installed.";
        }
    }
    // Add the TSP
    else
    {
	    DWORD   dwID;
		LONG retVal = lineAddProvider(pszProvider, 0, &dwID);
        switch( retVal )
        {
        case 0:
            if( MessageBox(0, "TSP successfully installed. Windows must be restarted.", pszTitle, MB_SETFOREGROUND) == IDOK )
            {
                ExitWindowsEx(EWX_REBOOT, 0);
            }
        break;

        case LINEERR_NOMULTIPLEINSTANCE:
            pszMessage = "TSP already installed.";
        break;

        default:
            pszMessage = "Unable to install TSP.";
        break;
        }
	}

    if( pszMessage )
    {
        MessageBox(0, pszMessage, pszTitle, MB_SETFOREGROUND);
    }

	return (int) 0;
} 



