/*
  Name: astmanager.h
  Copyright: Under the Mozilla Public License Version 1.1 or later
  Author: Nick Knight
  Date: 20/02/04 15:00
  Description: 
*/
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Asttapi.
 *
 * The Initial Developer of the Original Code is
 * Nick Knight.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): none
 *
 * Alternatively, the contents of this file may be used under the terms of
 * the GNU General Public License Version 2 or later (the "GPL")
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef ASTMANAGER_H
#define ASTMANAGER_H

#include <string>
#include <winsock.h>

#include "dll.h"

#include <map>


class astChannel
{
	//Encapsulate information regarding an Asterisk channel
	std::string state;
	std::string channel;
	std::string callerId;
};

class astEvent
{
public:
	astEvent() { event = 0;state = 0; }
	DWORD event;
	DWORD state;
	std::string channel;
	std::string context;
	std::string extension;
	std::string priority;
	std::string uniqueid;
	std::string callerId;
	std::string uniqueid1;
	std::string uniqueid2;
};

//at the moment I am not parsing for all of these types - but 
//for completness will list them here (grep from asterisk source!)
#define evShutdown 1
#define evHangup 2
#define evRename 3
#define evNewstate 4
#define evNewcallerid 5
#define evNewchannel 6
#define evLink 7
#define evUnlink 8
#define evExtensionStatus 9
#define evReload 10
#define evNewexten 11

//incoming ringing
#define stRinging 1
//the next one is a state just before dialing
#define stRing 2
#define stDial 3
#define stDown 4
#define stUp 5

// connection to our asterisk manager
class astManager
{
	public:
		// class constructor
		astManager();
		// class destructor
		~astManager();
		
		//setting up paramaters
		void setHost(std::string astHost);
		void setPort(DWORD astPort);
		
		//this next function sets the originators caller string
		//for example this would be
		//      "Sip/nick"
        void setOriginator(std::string channel);
        
        //outgoing channel would be as an example
        //       "CAPI:<number>:"
        //which we would then appent a number to.
		void setOutgoingChannel(std::string channel);
		//This sets the string we use to search the incoming
		//channel against i.e. Sip/nick of regex Sip/[nick|bob]
		void setInBoundChannel(std::string channel);
		void useInBoundRegex(bool YesNo);
		void setContext(std::string context);
		void setCallerID(std::string callerid);
		void setUsernamePassword(std::string username, std::string password);
		//things we can do
		SOCKET astManager::astConnect(void);
		DWORD originate(std::string destAddress);
		// Call this function to drop whatever call has been originated by this class. 
		// This is still to be completed.
		void dropChannel(std::string channel);
		// This function will wait for a time for the a messgage from Asterisk
		// te end of a message is marked by a \r\n\r\n
		astEvent* waitForMessage(void);
		DWORD login(void);

		
	protected:
	    //asterisk host
        std::string host;
        DWORD port;
        
        //asterisk username and password
        std::string user;
        std::string pass;
        
        //error string we maintain
        std::string error;
        
        //channels
        std::string originator;
        std::string outGoingChannel;
		std::string incomingChannel;
		bool useInComingRegex;

		//if we are dialing out by a context
		std::string context;

		//if we are setting a caller ID
		std::string callerid;
        
        //Our connection to the Asterisk server
        SOCKET s;

		//are we or aren't we?
		BOOL LOGGEDIN;
        
        //Private functions
        DWORD sendCommand(std::string command);
		
public:
	DWORD dropConnection(void);
};

#endif // ASTMANAGER_H

