/*
Name: tapiastmanager.cpp
Copyright: Under the Mozilla Public License Version 1.1 or later
Author: Nick Knight
Date: 19/04/04 15:00
Description: ties the astmanager connection to the extra information required for TAPI
*/
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Asttapi.
 *
 * The Initial Developer of the Original Code is
 * Nick Knight.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): none
 *
 * Alternatively, the contents of this file may be used under the terms of
 * the GNU General Public License Version 2 or later (the "GPL")
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


//we have to make sure we are thread safe - so need a mutex
#include "utilities.h"
#include ".\tapiastmanager.h"
#include "wavetsp.h"
#include <algorithm>
#include <cctype>

#include <boost/regex.hpp>

tapiAstManager::tapiAstManager(void)
{
	this->lineEvent = 0;
}

tapiAstManager::~tapiAstManager(void)
{
	this->dropConnection();
}

DWORD tapiAstManager::setTapiLine(HTAPILINE line)
{
	this->htLine = line;
	return 0;
}

HTAPILINE tapiAstManager::getTapiLine(void)
{
	return this->htLine;
}


DWORD tapiAstManager::processMessages(void)
{
	TSPTRACE("tapiAstManager::processMessages");

	std::string strData;

	//make sure we are logged in
	this->astConnect();
	this->login();

	//TODO perhaps some checking on the login - although the connection is 
	//dropped by Asterisk if the login is not accepted
	astEvent *ev;
	while ( (ev = this->waitForMessage()) != NULL )
	{
		try
		{


			TSPTRACE("Unique ID: %s\r\n",ev->uniqueid.c_str());
			TSPTRACE("Unique1 ID: %s\r\n",ev->uniqueid1.c_str());
			TSPTRACE("Unique2 ID: %s\r\n",ev->uniqueid2.c_str());
			TSPTRACE("Caller ID: %s\r\n",ev->callerId.c_str());
			TSPTRACE("Channel: %s\r\n",ev->channel.c_str());
			TSPTRACE("Context: %s\r\n",ev->context.c_str());
			TSPTRACE("Event: %i\r\n",ev->event);
			TSPTRACE("Extension: %s\r\n",ev->extension.c_str());
			TSPTRACE("Priority: %s\r\n",ev->priority.c_str());
			TSPTRACE("State: %i\r\n",ev->state);

			//First off find the associated call object
			tspMut.Lock();    //ensure we are thread safe again.

			//first off we see if we are already interested in this channel - i.e.
			//already have this unique id stored
			mapCall::iterator it;
			TSPTRACE("Number of entries in trackCalls %i\r\n",trackCalls.size());

			for( it = trackCalls.begin() ; it != trackCalls.end() ; it++ )
			{
				TSPTRACE("unique stored in map id is :%s\r\n", (*it).first.c_str() );

				TSPTRACE("Comparing :%s\r\n", ev->uniqueid.c_str());
				if ( ev->uniqueid == (*it).first )
				{
					break;
				}
				TSPTRACE("Comparing :%s\r\n", ev->uniqueid1.c_str());
				if ( ev->uniqueid1 == (*it).first )
				{
					break;
				}
				TSPTRACE("Comparing :%s\r\n", ev->uniqueid2.c_str());
				if ( ev->uniqueid2 == (*it).first )
				{
					break;
				}
			}

			if ( it == trackCalls.end() )
			{
				//If we don't find the unique id stored then we need to see if it is 
				//a channel we are interested in, this is donw with our inbound channel string
				//string compare or regex
				TSPTRACE("looking for channel");

				std::string uchan(this->incomingChannel);
				std::string incom(ev->channel);

				if ( this->useInComingRegex == true )
				{
					try
					{
						boost::regex e(uchan);
						boost::smatch what;

						if(!boost::regex_match(incom, what, e, boost::match_extra))
						{
							TSPTRACE("didn't find channel(regex)\r\n");
							//fetch our next message
							delete ev;
							ev = 0;
							tspMut.Unlock();
							continue;
						}
					}
					catch(std::exception e)
					{
						TSPTRACE("didn't find channel(regex) - exception caught\r\n");
						//fetch our next message
						delete ev;
						ev = 0;
						tspMut.Unlock();
						continue;
					}
				}
				else
				{
					transform(uchan.begin(), uchan.end(), uchan.begin(), std::toupper);
					transform(incom.begin(), incom.end(), incom.begin(), std::toupper);

					TSPTRACE("Looking for %s in %s\r\n",uchan.c_str(),incom.c_str());
					if ( incom.find(uchan) == -1 )
					{
						TSPTRACE("didn't find channel\r\n");
						//fetch our next message
						delete ev;
						ev = 0;
						tspMut.Unlock();
						continue;
					}
				}
				TSPTRACE("Found channel\r\n\r\n");
				astTspGlue tmp;
				//if it doesn't exsist, then we find one without a unique ID
				it = trackCalls.find("");

				if ( it == trackCalls.end() )
				{
					//If non of those exsiste then we create a new one - and signal the 
					//new call to TAPI.
					TSPTRACE("new call detected %s uniqueID",ev->uniqueid.c_str() );
					tmp.setAstChannelID(ev->channel);
					tmp.setTapiLine(this->htLine);
					tmp.setLineEvent(this->lineEvent);
					tmp.signalTapiNewCall();
					//need to check that this is actually incoming - not dialed.
					if ( ev->event == evNewchannel && ev->state == stRing )
					{
						tmp.signalTapiOutgoing();
						//tmp.signalTapiCallOffering();
					}
					else
					{
						tmp.signalTapiCallOffering();
					}
					TSPTRACE("Updating unique id :%s\r\n", ev->uniqueid.c_str());
					trackCalls[ev->uniqueid] = tmp;
				}
				else
				{
					//set the key to the unique ID - howto - for now just copy out and back in??
					TSPTRACE("inserting unique ID :%s\r\n", ev->uniqueid.c_str() );
					tmp = (*it).second;
					tmp.setAstChannelID(ev->channel);
					trackCalls.erase("");
					trackCalls[ev->uniqueid] = tmp;

				}
				//now make sure our iterator is correct.
				mapCall::iterator it = trackCalls.find(ev->uniqueid);

				if ( it == trackCalls.end() )
				{
					TSPTRACE("ERROR inserted but cannot find\r\n");
				}
			}
			tspMut.Unlock();

			TSPTRACE("Caller ID is %s\r\n",ev->callerId.c_str() );
			if ( ev->callerId != "" )
			{
	
				(*it).second.signalTapiCallerID(ev->callerId);
			}

			//when we get to here we must the call object in some fashion.

			TSPTRACE("Looking for event :%i\r\n", ev->event);
			//if this is a channel we are interested in...
			if ( ev->event == evHangup )
			{
				TSPTRACE("Hangup\r\n");
				//Signal TAPI
				(*it).second.signalTapiIdle();
				//remove it from our memory
				tspMut.Lock();
				trackCalls.erase(it);
				tspMut.Unlock();

			}
			//The states we are interested in passing up to TAPI.
			else if ( ev->state == stRinging )
			{
				(*it).second.signalTapiRinging();
			}
			else if ( ev->state == stUp )
			{
				TSPTRACE("Channel is up!!!!\r\n");
				//(*it).second.signalTapiConnected();
			}
			else if ( ev->event == evLink )
			{
				TSPTRACE("Channel is up (link)!!!!\r\n");
				(*it).second.signalTapiConnected();
			}
			else if ( ev->event == evNewexten )
			{
				TSPTRACE("Calling extension");
				(*it).second.signalTapiDialing(ev->extension);
			}

			delete ev;
			ev = 0;

		}
		catch(...)
		{
			TSPTRACE("tapiAstManager::processMessages exception");

			if ( ev )
			{
				delete ev;
				ev = 0;
				tspMut.Unlock();
			}

		}

	}

	TSPTRACE("completing tapiAstManager::processMessages");
	return 0;
}

DWORD tapiAstManager::addCall(astTspGlue call)
{
	BEGIN_PARAM_TABLE("TSPI_lineMakeCall")
		DWORD_IN_ENTRY(0)
		END_PARAM_TABLE()

		//we insert into th elist of possible calls
		//we have no defining link between this one and 
		//another... what to do!
		call.setTapiLine(this->htLine);
	call.setLineEvent(this->lineEvent);
	tspMut.Lock();
	trackCalls[""] = call;
	tspMut.Unlock();

	return EPILOG(0);
}

DWORD tapiAstManager::setLineEvent(LINEEVENT callBack)
{
	this->lineEvent = callBack;
	return 0;
}

astTspGlue * tapiAstManager::findCall(HDRVCALL tspCallID)
{
	tspMut.Lock();
	mapCall::iterator it;

	for ( it = this->trackCalls.begin() ; it != this->trackCalls.end() ; it ++ )
	{
		if ( (*it).second.getTspiCallID() == tspCallID )
		{
			tspMut.Unlock();
			return &(*it).second;
		}

	}

	tspMut.Unlock();
	return NULL;
}

DWORD tapiAstManager::getNumCalls(void)
{
	return this->trackCalls.size();
}
DWORD tapiAstManager::dropCall(HDRVCALL tspiID)
{
	astTspGlue *ourCall;

	if ( ( ourCall = this->findCall(tspiID)) != NULL )
	{
		this->dropChannel(ourCall->getAstChannelID());
	}
	return 0;
}

