/*
Name: utilities.h
Copyright: Under the Mozilla Public License Version 1.1 or later
Author: Nick Knight
Date: 20/02/04 15:00
Description: 
*/
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Asttapi.
 *
 * The Initial Developer of the Original Code is
 * Nick Knight.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): none
 *
 * Alternatively, the contents of this file may be used under the terms of
 * the GNU General Public License Version 2 or later (the "GPL")
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

//Public functions from this file

#include <windows.h>
#include <string>

#ifndef UTILITIES
#define UTILITIES

//One off time call to ensure we have a key for our configs
bool initConfigStore(void);

bool storeConfigString(std::string item, std::string str);
bool readConfigString(std::string item, std::string &str);
bool storeConfigInt(std::string item, DWORD str);
bool readConfigInt(std::string item, DWORD &str);

//some mutex simplification 
//courtsey of a doc@ http://world.std.com/~jimf/papers/c++sync/c++sync.html

#include "wavetsp.h"

class Mutex {
private:
	CRITICAL_SECTION lock;

public:
	Mutex(void) {
		TSPTRACE("Mutex::Mutex, %i\r\n", this);

		try
		{
			InitializeCriticalSection(&lock);
		}
		catch(...)
		{
			TSPTRACE("Mutex::Mutex exception\r\n");
		}
	}

	~Mutex() {
		TSPTRACE("Mutex::~Mutex, %i\r\n", this);

		try
		{
			//make sure no oneis waiting or using...
			this->Lock();
			DeleteCriticalSection(&lock);
		}
		catch(...)
		{
			TSPTRACE("Mutex::~Mutex exception\r\n");
		}
	}

	void Lock(void) {
		TSPTRACE("Mutex::Lock, %i\r\n", this);

		try
		{
			EnterCriticalSection(&lock);
		}
		catch(...)
		{
			TSPTRACE("Mutex::Lock exception\r\n");
		}
	}

	void Unlock(void) {
		TSPTRACE("Mutex::Unlock, %i\r\n", this);

		try
		{
			LeaveCriticalSection(&lock);
		}
		catch(...)
		{
			TSPTRACE("Mutex::Unlock exception\r\n");
		}
	}
};



#endif


